<?php
require_once('utility.php');

function switch_esxi_vm($argv) {
	/* check number of arguments */
	if(count($argv) != 5) {
		echo "Usage: switch_esxi_vm ESXI_HOST ESXI_USERNAME ESXI_PASSWORD ESXI_MACHINE_PATH [start|\"stop hard\"|\"stop soft\"]\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$esxi_machine_path = escapeshellarg($argv[3]);
	$operation = $argv[4];

	if(strcmp($operation, 'start') != 0 && strcmp($operation, 'stop hard') != 0 && strcmp($operation, 'stop soft') != 0) {
		echo 'invalid arguments: ' . $operation;
		exit(1);
	}

	/* execute main function */
    $portNumber = getEsxiPort($esxi_host);
	unset($result_array);
	exec("vmware-cmd --server $esxi_host --portnumber $portNumber --username $esxi_username --password $esxi_password $esxi_machine_path $operation 2>&1", $result_array, $return_value);
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

